/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	StoryScene
**
** DESCRIPTION:	Story telling scene
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef STORY_SCENE_H
#define STORY_SCENE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwScene.h"
#include "ldwButton.h"

class ldwTextControl;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CStoryScene : public ldwScene
{
private:

	enum EButton
	{
		eButton_Skip = 0,
		eButton_Yes,
		eButton_No,

		eButton_NumberOf
	};

	//class data
	static CStoryScene *	m_pInstance;

	ldwButton *				m_pButton[eButton_NumberOf];
	ldwTextControl *		clickLabel;
	bool					m_bAreTutorialTipButtonsShown;

	//class methods
	//setup
	private:	CStoryScene();
	private:	~CStoryScene();
	public:		static CStoryScene *Get();
	public:		static CStoryScene &Ref();
	public:		static void Destroy();

	//prevent copy
	public:		CStoryScene(const CStoryScene &);
	public:		CStoryScene & operator = (const CStoryScene &);

	//process
	public:		void Activate(bool bIsActive);

	public:		void DrawScene();
	public:		void UpdateScene();

	public:		bool HandleMessage(int iMessageID, long iData);
	public:		bool HandleMouse(int iMessageID, ldwPoint sMousePos);

	public:		void AddTutorialTipButtons();
	public:		void RemoveSkipButton();

	public:		void DisplayClickLabel();
	public:		void RemoveClickLabel();
			
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/